/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.duckyperiphs.hexcasting.utils;

import at.petrak.hexcasting.api.casting.iota.GarbageIota;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.casting.mishaps.MishapInvalidIota;
import at.petrak.hexcasting.common.lib.hex.HexIotaTypes;
import com.mojang.datafixers.util.Either;
import com.samsthenerd.duckyperiphs.DuckyPeriphs;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import org.jblas.DoubleMatrix;
import org.jetbrains.annotations.Nullable;
import ram.talia.moreiotas.api.casting.iota.EntityTypeIota;
import ram.talia.moreiotas.api.casting.iota.IotaTypeIota;
import ram.talia.moreiotas.api.casting.iota.ItemTypeIota;
import ram.talia.moreiotas.api.casting.iota.MatrixIota;
import ram.talia.moreiotas.api.casting.iota.StringIota;

public class MoreIotasIotaLuaUtils {
    @Nullable
    public static Iota getMoreIotasIota(Object luaObject) {
        String string;
        if (luaObject instanceof String && (string = (String)luaObject) != null) {
            try {
                return StringIota.make((String)string);
            }
            catch (MishapInvalidIota e) {
                DuckyPeriphs.logPrint("Invalid string iota (too long): " + string);
                return new GarbageIota();
            }
        }
        if (luaObject instanceof Map) {
            Map table = (Map)luaObject;
            if (table.containsKey("iotaType") && table.get("iotaType") instanceof String) {
                String typeKey = (String)table.get("iotaType");
                if (!class_2960.method_20207((String)typeKey)) {
                    return new GarbageIota();
                }
                class_2960 typeLoc = new class_2960(typeKey);
                IotaType type = (IotaType)HexIotaTypes.REGISTRY.method_10223(typeLoc);
                if (type == null) {
                    return new GarbageIota();
                }
                return new IotaTypeIota(type);
            }
            if (table.containsKey("entityType") && table.get("entityType") instanceof String) {
                String typeKey = (String)table.get("entityType");
                if (!class_2960.method_20207((String)typeKey)) {
                    return new GarbageIota();
                }
                class_2960 typeLoc = new class_2960(typeKey);
                class_1299 type = (class_1299)class_7923.field_41177.method_10223(typeLoc);
                if (type == null) {
                    return new GarbageIota();
                }
                return new EntityTypeIota(type);
            }
            if (table.containsKey("itemType") && table.get("itemType") instanceof String && table.containsKey("isItem") && table.get("isItem") instanceof Boolean) {
                String typeKey = (String)table.get("itemType");
                Boolean isItem = (Boolean)table.get("isItem");
                if (!class_2960.method_20207((String)typeKey)) {
                    return new GarbageIota();
                }
                class_2960 typeLoc = new class_2960(typeKey);
                if (isItem.booleanValue()) {
                    class_1792 type = (class_1792)class_7923.field_41178.method_10223(typeLoc);
                    if (type == null) {
                        return new GarbageIota();
                    }
                    return new ItemTypeIota(type);
                }
                class_2248 type = (class_2248)class_7923.field_41175.method_10223(typeLoc);
                if (type == null) {
                    return new GarbageIota();
                }
                return new ItemTypeIota(type);
            }
            if (table.containsKey("col") && table.get("col") instanceof Number && table.containsKey("row") && table.get("row") instanceof Number && table.containsKey("matrix") && table.get("matrix") instanceof Map) {
                int col = ((Number)table.get("col")).intValue();
                int row = ((Number)table.get("row")).intValue();
                DoubleMatrix matrix = new DoubleMatrix(row, col);
                Map matrixTable = (Map)table.get("matrix");
                for (int i = 1; i <= col * row; ++i) {
                    if (!matrixTable.containsKey(i) || !(matrixTable.get(i) instanceof Number)) continue;
                    matrix.put(i - 1, ((Number)matrixTable.get(i)).doubleValue());
                }
                try {
                    return new MatrixIota(matrix);
                }
                catch (MishapInvalidIota e) {
                    DuckyPeriphs.logPrint("Invalid matrix iota (too big?): " + matrix);
                    return new GarbageIota();
                }
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static Object getMoreIotasObject(Iota iota) {
        if (iota instanceof IotaTypeIota) {
            IotaType type = ((IotaTypeIota)iota).getIotaType();
            HashMap<String, String> typeTable = new HashMap<String, String>();
            Optional typeLoc = HexIotaTypes.REGISTRY.method_29113((Object)type);
            if (!typeLoc.isPresent()) {
                return null;
            }
            typeTable.put("iotaType", ((class_5321)typeLoc.get()).method_29177().toString());
            return typeTable;
        }
        if (iota instanceof EntityTypeIota) {
            class_1299 type = ((EntityTypeIota)iota).getEntityType();
            HashMap<String, String> typeTable = new HashMap<String, String>();
            Optional typeLoc = class_7923.field_41177.method_29113((Object)type);
            if (!typeLoc.isPresent()) {
                return null;
            }
            typeTable.put("entityType", ((class_5321)typeLoc.get()).method_29177().toString());
            return typeTable;
        }
        if (iota instanceof ItemTypeIota) {
            Either type = ((ItemTypeIota)iota).getEither();
            HashMap<String, Object> typeTable = new HashMap<String, Object>();
            Optional item = type.left();
            if (item.isPresent()) {
                Optional typeLoc = class_7923.field_41178.method_29113((Object)((class_1792)item.get()));
                if (!typeLoc.isPresent()) return null;
                typeTable.put("itemType", ((class_5321)typeLoc.get()).method_29177().toString());
                typeTable.put("isItem", true);
                return typeTable;
            } else {
                Optional block = type.right();
                if (!block.isPresent()) return null;
                Optional typeLoc = class_7923.field_41175.method_29113((Object)((class_2248)block.get()));
                if (!typeLoc.isPresent()) return null;
                typeTable.put("itemType", ((class_5321)typeLoc.get()).method_29177().toString());
                typeTable.put("isItem", false);
            }
            return typeTable;
        }
        if (iota instanceof StringIota) {
            return ((StringIota)iota).getString();
        }
        if (!(iota instanceof MatrixIota)) return null;
        DoubleMatrix matrix = ((MatrixIota)iota).getMatrix();
        HashMap<String, Serializable> matrixTable = new HashMap<String, Serializable>();
        matrixTable.put("col", Integer.valueOf(matrix.columns));
        matrixTable.put("row", Integer.valueOf(matrix.rows));
        HashMap<Double, Double> matrixData = new HashMap<Double, Double>();
        for (int i = 1; i <= matrix.columns * matrix.rows; ++i) {
            matrixData.put(Double.valueOf(i), matrix.get(i - 1));
        }
        matrixTable.put("matrix", matrixData);
        return matrixTable;
    }
}

